<?php

namespace App\Http\Controllers;

use App\Models\Admin\Aboutus;
use App\Models\Admin\Career;
use App\Models\Admin\Category;
use App\Models\Admin\Client;
use App\Models\Admin\ContactUsText;
use App\Models\Admin\HeavyEquipment;
use App\Models\Admin\PhotoGallery;
use App\Models\Admin\ProjectOverview;
use App\Models\Admin\Service;
use App\Models\Admin\Slider;
use App\Models\Admin\Website;
use App\Models\Admin\Project;
use App\Models\Admin\WelcomeBonus;
use Illuminate\Support\Facades\Validator;
use App\Models\Job;
use App\Models\JobWork;
use App\Models\Policy;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Models\ReferralProgram;
use App\Models\spin;
use App\Models\membership;
use App\Models\faq;
use App\Models\Admin\UserMessage;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    // public function __construct()
    // {
    //     $this->middleware('auth');
    // }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(Request $request)
    {
        if (Auth::check()) {
            if (auth()->user()->role_id == 1 || auth()->user()->role_id == 2) {
                return redirect()->route('admin.dashboard');
            }elseif (auth()->user()->role_id == 3) {
                return redirect()->route('user.dashboard');
            }
        }
        system_config_update();

        $request->session()->put('login_erro', '');
        $request->session()->put('mail_sent', '');
        
        $slider = Slider::all();
        $website = Website::latest()->first();
        $aboutus = Aboutus::latest()->first();
        $services = Service::orderBy('id', 'DESC')->latest()->limit('6')->get();
        $p_categorys = Category::orderBy('id', 'DESC')->latest()->get();
        $clients = Client::orderBy('id', 'DESC')->latest()->get();
        $jobs = Job::where('status', 1)->where('pause', 0)->where('worker_need', '!=', 'worker_confirmed')->orderBy('created_at', 'DESC')->limit(20)->get();

        return view('frontend.pages.home', compact('slider', 'website', 'aboutus', 'clients','services', 'p_categorys', 'jobs'));
    }
    
    public function refreshCaptcha()
    {
        return response()->json(['captcha'=> captcha_img()]);
    }

    public function about_us()
    {
        $slider = Slider::latest()->first();
        $website = Website::latest()->first();
        $aboutus = Aboutus::latest()->first();
        $p_categorys = Category::orderBy('id', 'DESC')->latest()->get();

        return view('frontend.pages.about-us', compact('slider', 'website', 'aboutus','p_categorys'));
    }
    public function referralProgram()
    {
        $referralProgram = new ReferralProgram();
    
        return view('frontend.pages.referral-program', compact('referralProgram'));
    }
    
    public function noticeBoard()
    {
        return view('user.pages.notice');
    }
    
    public function spin()
    {
        $spin = new spin();
        return view('user.pages.spin', compact('spin'));
    }
    
    public function membership()
    {
        $membership = new membership();
        return view('user.pages.membership', compact('membership'));
    }
    
    public function faq()
    {
        $faq = new faq();
        return view('frontend.pages.faq', compact('faq'));
    }


    public function service()
    {
        $slider = Slider::latest()->first();
        $website = Website::latest()->first();
        $services = Service::orderBy('id', 'DESC')->paginate(18);
        $p_categorys = Category::orderBy('id', 'DESC')->latest()->get();

        return view('frontend.pages.service', compact('slider', 'website', 'services','p_categorys'));
    }

    public function service_details($slug)
    {
        $slider = Slider::latest()->first();
        $website = Website::latest()->first();
        $service = Service::where('slug', $slug)->first();
        $services = Service::orderBy('id', 'DESC')->latest()->limit('5')->get();
        $p_categorys = Category::orderBy('id', 'DESC')->latest()->get();

        return view('frontend.pages.service-details', compact('slider', 'website', 'service', 'services','p_categorys'));
    }

    public function policy_details($slug)
    {
        $website = Website::latest()->first();
        $policy = Policy::where('slug', $slug)->first();

        return view('frontend.pages.policy-details', compact('website', 'policy'));
    }

    public function photo_gallery()
    {
        $slider = Slider::latest()->first();
        $website = Website::latest()->first();
        $photos = PhotoGallery::orderBy('id', 'DESC')->get();
        $p_categorys = Category::orderBy('id', 'DESC')->latest()->get();

        return view('frontend.pages.photo-gallery', compact('slider', 'website', 'photos','p_categorys'));
    }

    public function contact_us()
    {
        $slider = Slider::latest()->first();
        $website = Website::latest()->first();
        $contact_info = ContactUsText::latest()->first();
        $p_categorys = Category::orderBy('id', 'DESC')->latest()->get();

        return view('frontend.pages.contact-us', compact('slider', 'website', 'contact_info','p_categorys'));
    }

    public function career()
    {
        $slider = Slider::latest()->first();
        $website = Website::latest()->first();
        $career = Career::latest()->first();
        $p_categorys = Category::orderBy('id', 'DESC')->latest()->get();

        return view('frontend.pages.career', compact('slider', 'website', 'career','p_categorys'));
    }



    public function job_details($code)
    {
        $job = Job::where('code', $code)->first();
    
       //  if ($job->user_id == Auth::user()->id) {
       //  Redirect to the specified route
       //  return redirect()->route('user.my-job-details', $job->code);
       // }
       
       // if ($job->user_id == Auth::user()->id) {
       //    return redirect()->back()->with('error', 'This is your job!');
       //}
        
        $mineJob = $job->user_id == Auth::user()->id;
        
        $datas = JobWork::where('user_id', Auth::user()->id)
                        ->where('job_id', $job->id) 
                        ->get();
    
        $check_work = JobWork::where('user_id', Auth::user()->id)->where('job_id', $job->id)->count();
        
        $workReview = $check_work > 0;
        
        //if ($check_work > 0) {
        //    return redirect()->back()->with('error', 'Already applied this job!');
        //}
    
        $check_work_done = JobWork::where('job_id', $job->id)->where('status', '!=', 2)->count();
        
        $workLimitOver = $check_work_done >= $job->worker_need;
        
    
        $title = 'Job details';
    
        return view('user.pages.job-details', compact('title', 'job', 'workReview', 'workLimitOver', 'check_work_done', 'mineJob', 'datas'));
    }



    public function app_config(Request $request){
        app_config();
        return redirect()->back();
    }
    
    public function user_register(Request $request)
    {
        // Validate input
        $request->validate([
            'name' => 'required',
            'email' => 'required|unique:users',
            'password' => 'required',
            'country' => 'required',
        ]);
    
        // Collect device IP and user-agent
        $ip_address = $request->ip();
        $device_name = $request->header('User-Agent');
        // return $user_agent;
        // Check for existing registration from this device
        // $existingUser = User::where('device_name', $device_name)->first();
        // if ($existingUser) {
        //     return redirect('/register')->with('error', 'Registration is allowed only once from this device.');
        // }
        // Remaining registration logic
        $welcome_bonus = WelcomeBonus::latest()->first();
        $last_ac = User::select('id')->latest()->first();
        $code = $last_ac ? sprintf('%04d', $last_ac->id + 1000001) : sprintf('%04d', 1000001);
    
        $user = new User();
        $user->role_id = 3;
        $user->code = $code;
        $user->name = $request->name;
        $user->email = $request->email;
        $user->country = $request->country;
        $user->password = Hash::make($request->password);
        $user->pass_text = $request->password;
        $user->ip_address = $ip_address;
        $user->device_name = $device_name;
        $user->save();
    
        // Apply welcome bonus
        if ($welcome_bonus) {
            $user->earning_balance = $user->earning_balance + $welcome_bonus->amount;
            $user->save();
        }
    
        return redirect()->route('login')->with('success', 'Registration successful!');
    }

    public function refer_user_register(Request $request)
    {
       
        $request->validate([
            'name' => 'required',
            'email' => 'required|unique:users',
            'password' => 'required',
            'country' => 'required',
        ]);

        $welcome_bonus = WelcomeBonus::latest()->first();

        $last_ac = User::select('id')->latest()->first();
        if (isset($last_ac)) {
            $code = sprintf('%04d', $last_ac->id + 1000001);
        } else {
            $code = sprintf('%04d', 1000001);
        }

        $ck_refered_user = User::where('code', $request->user_code)->first();

        $user = new User();
        $user->role_id = 3;
        $user->code = $code;
        $user->name = $request->name;
        $user->email = $request->email;
        $user->country = $request->country;
        $user->password = Hash::make($request->password);
        $user->pass_text = $request->password;
        $user->rfered_by = $ck_refered_user->id;
        // return $user;
        $user->save();

        $refered_user = User::find($ck_refered_user->id);
        $refered_user->total_refer = $refered_user->total_refer + 1;
        $refered_user->save();

        $check_user = User::where('code', $code)->where('email', $request->email)->first();
        if($check_user){
            $s_user = User::find($check_user->id);
            $s_user->earning_balance = $s_user->earning_balance + $welcome_bonus->amount;
            $s_user->save();
        }

        return redirect()->route('login')->with('message', 'Your Account Register Success. Please log in.');
    }

    public function foreget_password()
    {
        $website = Website::latest()->first();
        $msg = '';
        return view('auth.forget-password', compact('website','msg'));
    }

    public function recover_password(Request $request)
    {
        $request->validate([
            'email' => 'required',
        ]);
        $ck_user = User::where('email', $request->email)->first();
        if($ck_user){
            
            $new_password = rand(100000,999999);
            
            $up_user = User::find($ck_user->id);
            $up_user->password = Hash::make($new_password);
            $up_user->save();
            
            $data = array(
                'name' => $ck_user->name,
                'email' => $ck_user->email,
                'phone' => $ck_user->phone,
                'subject' => 'Password Recover',
                'new_password' => $new_password
            );

            Mail::send('email', $data, function ($mail) use ($data) {
                $mail->from('admin@powerworkerearn.com', website_info()->title)
                    ->to($data['email'], website_info()->title)
                    ->subject($data['subject']);
            });
            
            $request->session()->put('mail_sent', 'One time password sent in your mail, Check junk/Spam folders. You will receive within 5 minutes');
            
            return redirect()->route('login');
        }else{
            $request->session()->put('mail_sent', '');
            $website = Website::latest()->first();
            $msg = 'Email not valid! Please enter valid email';
            return view('auth.forget-password', compact('website','msg'));
        }
    }

    public function admin_login()
    {
        $website = Website::latest()->first();
        return view('auth.admin-login', compact('website'));
    }

    public function user_logout()
    {
        $user = Auth::user();
        $user->activity = 0;
        $user->save();
        Auth::logout();

        return redirect()->route('home');
    }

    public function reload_captcha()
    {
        $original_string = array_merge(range(0,9), range('a','z'), range('A', 'Z'));
        $original_string = implode("", $original_string);
        $data = substr(str_shuffle($original_string), 0, 6);
        return response()->json(['captcha'=>$data]);
    }
    public function postback_timewall(Request $request){
            
        $allowedIPs = ['173.44.49.203'];
    
        $clientIP = $request->ip();
  
        if (!in_array($clientIP, $allowedIPs)) {
            return response()->json(['status' => 'error', 'message' => 'Unauthorized IP address'], 403);
        }

        $userId = $request->query('userID');
        $transactionId = $request->query('transactionID');
        $revenue = $request->query('revenue') ?? 0.0;
        $currencyAmount = $request->query('currencyAmount') ?? 0.0;
        $hash = $request->query('hash'); // Retrieve the hash from the request
        $type = $request->query('type') ?? 'credit';
     
        $secretKey = 'f194ff2b04dec44523816b970c7c5174'; // Secret key provided by Time Wall
        $expectedHash = hash('sha256', $userId . $revenue . $secretKey);
    
      
        if ($hash !== $expectedHash) {
            return response()->json(['status' => 'error', 'message' => 'Invalid hash'], 403);
        }
     
      
        $user = User::find($userId);
        if (!$user) {
            return response()->json(['status' => 'error', 'message' => 'User not found'], 404);
        }
        // Handle credit or chargeback
        if ($type === 'chargeback') {
            // Deduct currency and log chargeback
            $user->earning_balance -= abs($currencyAmount);
        } else {
            // Ensure currency amount is a positive number
            if ($currencyAmount > 0) {
                $user->earning_balance += $currencyAmount;
            } else {
                return response()->json(['status' => 'error', 'message' => 'Invalid currency amount'], 400);
            }
        }
    
        // Save user balance update
        $user->save();
        
        $data = new UserMessage();
        $data->user_id = $userId;  // Make sure to use $userId
        $data->message_title = 'Time Wall!';
        $data->message = 'Your recent withdrawal of $' . ($currencyAmount) . ' has been processed successfully on Time Wall.';
        $data->message = 'Your recent withdrawal of $' . number_format(($currencyAmount), 3) . ' has been processed successfully on Time Wall.';
        $data->save();

    
        return response()->json(['status' => 'success', 'message' => 'Postback processed successfully']);
    }
}
